//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
void OnStart(void)
{
    const ushort info = 0xCADA;

    PrintFormat("Before modification: 0x%I64X", info);
    PrintFormat("After modification : 0x%I64X", Swap(info));
}
//+------------------------------------------------------------------+
template <typename T>
T Swap(T arg)
{
    union un_01
    {
        T     value;
        uchar u8_bits[sizeof(T)];  
    }info;

    info.value = arg;

    PrintFormat("The region is composed of %d bytes", sizeof(info));

    for (uchar i = 0, j = sizeof(info) - 1, tmp; i < j; i++, j--)
    {
        tmp = info.u8_bits[i];
        info.u8_bits[i] = info.u8_bits[j];
        info.u8_bits[j] = tmp;
    }

    return info.value;
}
//+------------------------------------------------------------------+